local assets =
{
    Asset("ANIM", "anim/mine_worm_home.zip"),
    Asset("SOUND", "sound/common.fsb"),
	Asset("ATLAS", "images/inventoryimages/compressor.xml")
	
	
}

local prefabs =
{
    "seeds",
}

local function onopen(inst) 	
    inst.AnimState:PlayAnimation("idle2")
	inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/charged", "overcharge_sound")
end 

local function onclose(inst) 
	inst.AnimState:PlayAnimation("idle")
	inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/charged", "overcharge_sound")
end 
local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddMiniMapEntity()
    inst.entity:AddNetwork()

    inst.AnimState:SetBank("mine_worm_home")
    inst.AnimState:SetBuild("mine_worm_home")
    inst.AnimState:PlayAnimation("idle", true)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
    inst:AddComponent("container")
    inst.components.container:WidgetSetup("compressor") 
    inst.components.container.onopenfn = onopen
    inst.components.container.onclosefn = onclose
    inst:AddComponent("inspectable")

    ---------------------        
    ---------------------   
	inst.entity:AddDynamicShadow()
	inst.DynamicShadow:SetSize( 4,4 )
	MakeObstaclePhysics(inst, .2)
	

    return inst
end

return Prefab("compressor", fn, assets, prefabs),
MakePlacer("compressor_placer", "mine_worm_home", "mine_worm_home", "idle")